"""
Przykład z podrozdziału "Wieloprocesowość"
pokazujący, jak używać potoków z modułu
`multiprocessing` jako kanału komunikacyjnego.

"""
from multiprocessing import Process, Pipe


class CustomClass:
    pass


def worker(connection):
    while True:
        instance = connection.recv()
        if instance:
            print(f"POTOMNY: otrzymane: {instance}")
        if instance is None:
            break


def main():
    parent_conn, child_conn = Pipe()

    child = Process(target=worker, args=(child_conn,))

    for item in (
        42,
        "jakiś tekst",
        {"jeden": 1},
        CustomClass(),
        None,
    ):
        print("RODZIC: wysłane: {}".format(item))
        parent_conn.send(item)

    child.start()
    child.join()


if __name__ == "__main__":
    main()
